/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mod_compat_vr.shaders;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.commons.lang3.tuple.Triple;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.render.VRShaders;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.render.helpers.opengl.OpenGLHelper;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mod_compat_vr.iris.IrisHelper;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;

public class ShadersHelper {
    private static List<Triple<String, UniformType, Supplier<?>>> UNIFORMS;

    public static int ShaderLight() {
        return ShadersHelper.isShaderActive() ? 8 : 4;
    }

    public static void bindTexture(class_2960 resourceLocation) {
        if (ShadersHelper.isShaderActive()) {
            GpuTexture view = RenderHelper.getGpuTexture(resourceLocation);
            RenderSystem.setShaderTexture((int)0, (GpuTexture)view);
            OpenGLHelper.bindTexture(0, view);
        }
    }

    public static boolean isShaderActive() {
        return IrisHelper.isLoaded() && IrisHelper.isShaderActive() || OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive();
    }

    public static boolean needsSameSizeBuffers() {
        return OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive();
    }

    public static boolean isRenderingShadows() {
        return IrisHelper.isLoaded() && IrisHelper.isShaderActive() && IrisHelper.isRenderingShadows() || OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive() && OptifineHelper.isRenderingShadows();
    }

    public static void maybeReloadShaders() {
        if (IrisHelper.isLoaded()) {
            IrisHelper.reload();
        }
    }

    public static void addMacros(Consumer<String> createMacro, BiConsumer<String, Integer> createValueMacro) {
        createMacro.accept("VIVECRAFT");
        for (RenderPass pass : RenderPass.values()) {
            createValueMacro.accept("VIVECRAFT_PASS_" + pass.toString(), pass.ordinal());
        }
    }

    public static List<Triple<String, UniformType, Supplier<?>>> getUniforms() {
        if (UNIFORMS == null) {
            UNIFORMS = new ArrayList();
            ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
            class_310 mc = class_310.method_1551();
            UNIFORMS.add(Triple.of((Object)"vivecraftRelativeMainHandPos", (Object)((Object)UniformType.VECTOR3F), () -> {
                if (VRState.VR_RUNNING) {
                    return MathUtils.subtractToVector3f(mc.field_1773.method_19418().method_19326(), RenderHelper.getControllerRenderPos(0));
                }
                return MathUtils.ZERO;
            }));
            UNIFORMS.add(Triple.of((Object)"vivecraftRelativeMainHandRot", (Object)((Object)UniformType.MATRIX4F), () -> {
                if (VRState.VR_RUNNING) {
                    return dh.vrPlayer.getVRDataWorld().getController(0).getMatrix();
                }
                return MathUtils.IDENTITY;
            }));
            UNIFORMS.add(Triple.of((Object)"vivecraftRelativeOffHandPos", (Object)((Object)UniformType.VECTOR3F), () -> {
                if (VRState.VR_RUNNING) {
                    return MathUtils.subtractToVector3f(mc.field_1773.method_19418().method_19326(), RenderHelper.getControllerRenderPos(1));
                }
                return MathUtils.ZERO;
            }));
            UNIFORMS.add(Triple.of((Object)"vivecraftRelativeOffHandRot", (Object)((Object)UniformType.MATRIX4F), () -> {
                if (VRState.VR_RUNNING) {
                    return dh.vrPlayer.getVRDataWorld().getController(1).getMatrix();
                }
                return MathUtils.IDENTITY;
            }));
            UNIFORMS.add(Triple.of((Object)"vivecraftIsVR", (Object)((Object)UniformType.BOOLEAN), () -> VRState.VR_RUNNING));
            UNIFORMS.add(Triple.of((Object)"vivecraftRenderpass", (Object)((Object)UniformType.INTEGER), () -> ClientDataHolderVR.getInstance().currentPass.ordinal()));
        }
        return UNIFORMS;
    }

    public static void registerPipelines() {
        BiConsumer<RenderPipeline, String> consumer = null;
        if (IrisHelper.isLoaded()) {
            consumer = IrisHelper::registerPipeline;
        }
        if (consumer != null) {
            consumer.accept(VRShaders.CROSSHAIR_WORLD, "ENTITIES");
            consumer.accept(VRShaders.CROSSHAIR_WORLD_ALWAYS, "ENTITIES");
            consumer.accept(VRShaders.ENTITY_TRANSLUCENT_ALWAYS_NO_CARDINAL_LIGHT, "ENTITIES_TRANSLUCENT");
            consumer.accept(VRShaders.ENTITY_TRANSLUCENT_NO_CARDINAL_LIGHT, "ENTITIES_TRANSLUCENT");
            consumer.accept(VRShaders.ENTITY_CUTOUT_NO_CULL_NO_CARDINAL_LIGHT, "ENTITIES");
            consumer.accept(VRShaders.ENTITY_CUTOUT_NO_CULL_ALWAYS_NO_CARDINAL_LIGHT, "ENTITIES");
            consumer.accept(VRShaders.ENTITY_SOLID_NO_CARDINAL_LIGHT, "ENTITIES");
            consumer.accept(VRShaders.QUADS, "BASIC");
            consumer.accept(VRShaders.QUADS_ALWAYS, "BASIC");
            consumer.accept(VRShaders.TRIANGLES_ALWAYS, "BASIC");
            consumer.accept(VRShaders.TRIANGLE_FAN_ALWAYS, "BASIC");
            consumer.accept(VRShaders.TEXT_NO_CULL, "ENTITIES_TRANSLUCENT");
        }
    }

    public static enum UniformType {
        MATRIX4F,
        VECTOR3F,
        INTEGER,
        BOOLEAN;

    }
}

